<?php
/* --------------------------------------------------------------
 RebuildRegistryHandler.php 2020-04-06
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Application\Plugins\Utility;

use Gambio\Core\Application\Plugins\PluginRegistryService;

/**
 * Class RebuildRegistryHandler
 * @package Gambio\Core\Application\Plugins\Utility
 */
class RebuildRegistryHandler
{
    /**
     * @var PluginRegistryService
     */
    private $pluginRegistryService;
    
    
    /**
     * RebuildRegistryHandler constructor.
     *
     * @param PluginRegistryService $pluginRegistryService
     */
    public function __construct(PluginRegistryService $pluginRegistryService)
    {
        $this->pluginRegistryService = $pluginRegistryService;
    }
    
    
    /**
     * Callback that rebuilds the plugins registry by using the plugin registry service.
     *
     * @param RebuildPluginRegistry $command
     *
     * @return RebuildPluginRegistry
     */
    public function __invoke(RebuildPluginRegistry $command): RebuildPluginRegistry
    {
        $this->pluginRegistryService->rebuild();
        
        return $command;
    }
}